#!/bin/bash

run() {
	chainType=
	logFile="safe.log"
	if [ $# -ge 1 ]; then
		if [ "$1" == "--safetest" ]; then
			chainType="--safetest"
			logFile="safe-testnet.log"
			shift
		fi
	fi

	if [ -z "$chainType" ]; then
		rm ~/.safe4/geth/nodes -rf
	else
		rm ~/.safe4/safetest/geth/nodes -rf
	fi

	if [ -f "$logFile" ]; then
		t=$(date +%Y%m%d.%H%M%S)
		mv $logFile $logFile.$t
	fi

	if [ $# -eq 0 ]; then
		nohup ./bin/geth $chainType --rpc.evmtimeout=0 >>$logFile 2>&1 &
	elif [ $# -eq 1 ]; then
		nohup ./bin/geth $chainType --nat extip:$1 --rpc.evmtimeout=0 >>$logFile 2>&1 &
	else
		cp ./bin/static-nodes.json ~/.safe4/static-nodes.json
		nohup ./bin/geth $chainType --nat extip:$1 --rpc.evmtimeout 240s --maxpeers 500 --maxpendpeers 500 --unlock $2 --password ./bin/password.txt --mine --miner.etherbase $2 >>$logFile 2>&1 &
	fi
}

while true
do
	temp=`ps aux | grep geth | grep evmtimeout | grep -v grep`
	if [ -z "$temp" ]; then
		echo "$(date +%Y%m%d.%H%M%S) restart geth..."
		run $@
	fi
	sleep 40
done

